/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ext.s2jdbc.wizards;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;

/**
 * 
 * TableKeyEventHandlerNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/02/08 ZIGEN create.
 * 
 */
public class TableKeyEventHandler2 {
	
	protected TableViewer viewer;
	
	protected Table table;
	
	/**
	 * RXgN^
	 * 
	 */
	public TableKeyEventHandler2(TableViewer viewer) {
		this.viewer = viewer;
		this.table = viewer.getTable();
	}
	
	/**
	 * IĂsԍ擾
	 * 
	 * @return
	 */
	public int getSelectedRow() {
		return table.getSelectionIndex(); // si擪0)
	}
	
	public void selectRow(int index) {
		table.select(index);
	}
	
	/**
	 * IĂԍ擾
	 * 
	 * @return
	 */
	public int getSelectedCellEditorIndex() {
		int defaultIndex = 0;
		CellEditor[] editors = viewer.getCellEditors();
		if (editors == null)
			return -1;
		for (int i = 0; i < editors.length; i++) {
			if (editors[i] != null && editors[i].isActivated()) {
				return i;
			}
		}
		return defaultIndex;
	}
	
	/**
	 * ҏW\Ȏ̗ԍ擾
	 * 
	 * @param cuurentCol
	 * @return
	 */
	public int getEditableNextColumn(int cuurentCol) {
		ICellModifier modifier = viewer.getCellModifier();
		// int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 1;
		int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 2;// (_~[l)
		// int nextCol = (cuurentCol < table.getColumnCount() - 2) ? cuurentCol + 1 : 2;// (`FbN{bNXl)
		
		System.out.println("nextCol = " + nextCol);
		return nextCol;
	}
	
	/**
	 * ҏW\ȑO̗ԍ擾
	 * 
	 * @param CurrentCol
	 * @return
	 */
	public int getEditablePrevColumn(int CurrentCol) {
		ICellModifier modifier = viewer.getCellModifier();
		// int nextCol = (CurrentCol == 1) ? table.getColumnCount() - 1 : CurrentCol - 1;
		int nextCol = (CurrentCol == 2) ? table.getColumnCount() - 1 : CurrentCol - 1; // (_~[l)
		// int nextCol = (CurrentCol == 2) ? table.getColumnCount() - 1 : CurrentCol - 1; // (`FbN{bNXl)
		System.out.println("nextCol = " + nextCol);
		return nextCol;
	}
	
	/**
	 * w肵JҏW[hɂ
	 * 
	 * @param rowIndex
	 *            sԍ
	 * @param columnIndex
	 *            ԍ
	 */
	public void editTableElement(int rowIndex, int columnIndex) {
		Object element = viewer.getElementAt(rowIndex);
		if (element != null) {
			
			// ܂XN[ĕҏW[hɂȂȂ
			// viewer.editElement(element, columnIndex);
			// table.showColumn(table.getColumn(columnIndex));
			
			// ԓꂩ邱ƂŁA܂XN[{ҏW[hɂȂ
			if (columnIndex == 1) {
				table.showColumn(table.getColumn(0)); // sԍ悤ɂ
			} else {
				table.showColumn(table.getColumn(columnIndex));
			}
			viewer.editElement(element, columnIndex);
			
		}
	}
	
	/**
	 * ʏ̃JXV
	 * 
	 */
	public void updateColumn(FormProperty element, int col, Object newValue) {
		
		// TableElement̒lXVAҏWς݃Xgɒǉ
		// element.updateItems(col - 1, newValue);// row-1
		
		element.setValue(col, String.valueOf(newValue));
		
		// e[uEr[XV
		viewer.update(element, null);
		columnsPack();
		
	}
	
	public void setMessage(String msg) {
		DbPlugin.getDefault().showWarningMessage(msg);
	}
	
	/**
	 * Rowԍ̃JPack
	 */
	private void columnsPack() {}
	
	
	/**
	 * ̓`FbNэXVf[^TableElementɓo^
	 * 
	 * @param row
	 * @param col
	 * @return
	 */
	public boolean validate(int row, int col) {
		FormProperty element = (FormProperty) viewer.getElementAt(row);
		Object newValue = null;
		CellEditor editor = viewer.getCellEditors()[col];
		if (editor == null)
			throw new IllegalStateException("CellEditorݒ肳Ă܂"); //$NON-NLS-1$
			
		// int columnIndex = -1;
		
		if (editor instanceof TextCellEditor) {
			TextCellEditor tce = (TextCellEditor) editor;
			newValue = tce.getValue();
		}
		Object oldValue = element.getValue(col);
		
		// if (!oldValue.equals(newValue)) {
		// String msg = editor.getErrorMessage();
		// if (msg == null) {
		// // ڍXV
		// updateColumn(element, col, newValue);
		// return true; // 
		//
		// } else {
		// // ҏWLZ(modifyĂ΂Ȃ悤ɂ)
		// viewer.cancelEditing();
		// // ڂXV
		// updateColumn(element, col, newValue);
		// // G[bZ[W\
		// setMessage(msg); //$NON-NLS-1$
		// // ͌̃JҏWԂɂ
		// editTableElement(row, col);
		// return false; // s
		// }
		//
		// }
		
		String msg = editor.getErrorMessage();
		if (msg == null) {
			// ڍXV
			updateColumn(element, col, newValue);
			return true; // 
			
		} else {
			// ҏWLZ(modifyĂ΂Ȃ悤ɂ)
			viewer.cancelEditing();
			// ڂXV
			updateColumn(element, col, newValue);
			// G[bZ[W\
			setMessage(msg); //$NON-NLS-1$
			// ͌̃JҏWԂɂ
			editTableElement(row, col);
			return false; // s
		}
		

	}
	
	// public boolean validateAll() {
	// // log.debug("validateAll");
	// try {
	// int row = getSelectedRow();
	//
	// if (row == -1) {
	// ;// CTRL+C̏ꍇ͂
	// } else {
	// FormProperty element = (FormProperty) viewer.getElementAt(row);
	// IDBConfig config = element.getTable().getDbConfig();
	// IValidatorFactory factory = AbstractValidatorFactory.getFactory(config);
	// zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
	// String msg = null;
	// for (int col = 0; col < columns.length; col++) {
	// //
	// // if(!validate(row, col+1)){
	// // return false;
	// // }
	//
	//
	// Object[] items = element.getItems();
	// msg = factory.validate(columns[col], items[col]);
	// if (msg != null) {
	// viewer.cancelEditing();
	// setMessage(msg);
	// editTableElement(row, col + 1); // rowǉ (ł col+1)
	// return false;
	// }
	// }
	// }
	//
	// } catch (Exception e) {
	// e.printStackTrace();
	// DbPlugin.getDefault().showErrorDialog(e);
	// }
	// return true;
	// }
	
	/**
	 * ʏ̐VKpR[h폜 f[^x[Xւ̍폜͍sȂi܂łڏj
	 * 
	 */
	public void removeRecord(FormProperty element) {
		TableViewerManager.remove(viewer, element);
	}
	
	/**
	 * RlNV̊J
	 */
	public void dispose() {}
	
	
	/**
	 * e[uɐVKo^p̃R[h\
	 * 
	 */
	public void createNewRecord() {
		
		int count = table.getItems().length;
		
		FormProperty fp = new FormProperty();
		fp.no = count + 1;
		fp.name = "";
		fp.type = "String";
		fp.modified = FormProperty.MODIFIED_PUBLIC;
		
		addFormProperty(viewer, fp);
		// PJ(RoẃjҏW
		// editTableElement(count, 1); // ŏIR[h1JڂҏW
		editTableElement(count, 2); // ŏIR[h2JڂҏW(_~[l)
		
	}
	
	@SuppressWarnings("unchecked")
	private void addFormProperty(TableViewer viewer, FormProperty newProperty) {
		Object obj = viewer.getInput();
		if (obj instanceof List<?>) {
			List<FormProperty> list = (List<FormProperty>) obj;
			list.add(newProperty);
			viewer.setInput(list);
			
		} else {
			throw new IllegalArgumentException("TableViewerɊi[ĂIuWFNgقȂ܂"); //$NON-NLS-1$
		}
	}
}
